---
title: flux-schnell API Usage Guide
slug: 6DCWoM_fbbp1XuSHH8vAw
createdAt: Thu Jul 18 2024 06:12:37 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:40:04 GMT+0000 (Coordinated Universal Time)
---

# flux-schnell API Usage Guide

## Introduction

This document will guide developers on how to use the aonweb library to call the flux-schnell API, The fastest image generation model tailored for local development and personal use.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
   input:{
      "prompt": "black forest gateau cake spelling out the words \\"FLUX SCHNELL\\", tasty, food photography, dynamic shot",
      "num_outputs": 1,
      "aspect_ratio": "1:1",
      "output_format": "webp",
      "output_quality": 90
    }
};
```

```js
const data = {
   input:{
      "num_outputs": 1,
      "prompt": "POV someone holding their hand up, stunning black forest mountains",
      "aspect_ratio": "1:1",
      "output_format": "webp",
      "output_quality": 90
    }
};
```

```js
const data = {
   input:{
      "num_outputs": 1,
      "prompt": "3 magical wizards stand on a yellow table\\nOn the left, a wizard in black robes holds a sign that says ‘AI’\\nIn the middle, a witch in red robes holds a sign that says ‘is’\\nand on the right, a wizard in blue robes holds a sign that says ‘cool’\\nBehind them a purple dragon",
      "aspect_ratio": "1:1",
      "output_format": "webp",
      "output_quality": 90
    }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/flux-schnell@iAON", data, price);
    // Handle response
     console.log("Flux-Schnell result:", response);
} catch (error) {
    // Error handling
    console.error("Error generating :", error);
}
```

### Parameter Description

- `num_outputs`: Number, Number of outputs to generate.
- `prompt`: String, Prompt for generated image.
- `aspect_ratio`: String, Aspect ratio for the generated image.
- `output_format`: String, Format of the output images.
- `output_quality`: Number,Quality when saving the output images, from 0 to 100. 100 is best quality, 0 is lowest quality. Not relevant for .png outputs

### Notes

- The API may take some time to process the input and generate the result, consider implementing appropriate wait or loading states.
- Handle possible errors, such as network issues, invalid input, or API limitations.

### Example Response

The API response will contain the URL of the generated image or other relevant information. Parse and use the response data according to the actual API documentation.
